#delimit ;
clear;
capture log close;
set memory 400m;
set more 1;
local UNIX 0;
* set this to 1 if include 2020 wave;
global INCLUDE2020 1;
********************************************************************;
* important note: "tenureX" is not tenure, but date the respondent *;
* began working, in wave X *****************************************;
* also, do not bother coding the "change" variable *;

global folder "D:\Dropbox";
*global folder "\\econ-san-fs\Home4\uctpkp0\SystemFolder\Windows7\Desktop";
*global folder "\\ad.ucl.ac.uk\homer\zctpmer\Downloads"; 
*global folder "C:\Users\Jeremy\Dropbox";

         local saved  "$folder\hrs\merge\";
         local trackd "$folder\hrs\tracker\";
         local wave1d "$folder\hrs\wave1\";
         local wave2d "$folder\hrs\wave2\";
         local wave3d "$folder\hrs\wave3\";
         local wave4d "$folder\hrs\wave4\";
         local wave5d "$folder\hrs\wave5\";
		 local wave6d "$folder\hrs\wave6\";
         local wave7d "$folder\hrs\wave7\";
         local wave8d "$folder\hrs\wave8\";
		 local wave9d "$folder\hrs\wave9\";
		 local wave10d "$folder\hrs\wave10\";
		 local wave11d "$folder\hrs\wave11\";
		 local wave12d "$folder\hrs\wave12\";
		 local wave13d "$folder\hrs\wave13\";
		 local wave14d "$folder\hrs\wave14\";
		 local wave15d "$folder\hrs\wave15\";

         local aheadw1 "$folder\hrs\aheadw1\";
         local aheadw2 "$folder\hrs\aheadw2\";




*log using `saved'tenure.log, replace ;
program drop _all;


* Wave 1*;
use `wave1d'employer;
gen tenure1=.;gen job1=.; gen reason1=.;

replace tenure1=V2816 if V2816>0 & V2816<1993;
replace tenure1=1992 if V2816==1993;
*V2816 - when did you start working for this employer;

replace job1=V2721 if V2721>0 & V2721<1993;
*V2718 - working for self, 2 and someone else, 1;
*V2721 - when did you start doing this kind of work;

keep HHID PN tenure1 job1 reason1;
sort HHID PN ;
sleep 1000; save `saved'tenure, replace;
drop _all;

* Wave 2*;
use `wave2d'w2fa;
gen tenure2=.;gen change2=.;gen job2=.;gen reason2=.;gen counter2=.;

replace change2=0 if W3458==1;
replace change2=1 if W3458==5;
*W3458 still working for previous wave employer, 1 yes 5 no;

replace tenure2=W3663 if W3663<1995 & W3663>0;
replace tenure2=1994 if W3663==1995;
*W3663 year started working for current employer;
*W3300 - 1 is working now;

replace job2=W3616 if W3616<1995 & W3616>0;
*W3616 year started doing this kind of work;

replace reason2=W3507 if W3507<=3 & W3507>=1;
*W3507 FA28 Why did you leave employer, interested in 1-3;

replace counter2=1 if tenure2~=. & reason2~=.;

keep HHID PN tenure2 change2 job2 reason2 counter2;
sort HHID PN;
merge HHID PN using `saved'tenure;
drop _merge;
gen temp=real(HHID);
drop HHID;
gen HHID=temp;
drop temp;
gen temp=real(PN);
drop PN;
gen PN=temp;
drop temp;
sort HHID PN;
sleep 1000; save `saved'tenure, replace;
drop _all;


*wave 3*;
use `wave3d'H96G_R.DTA;
gen temp=real(HHID);
drop HHID;
gen HHID=temp;
drop temp;
gen temp=real(PN);
drop PN;
gen PN=temp;
drop temp;

gen tenure3=.;gen change3=.;gen job3=.;gen reason3=.;gen counter3=.;

replace change3=1 if E2668>1993 & E2668<1998;
*E2668 G26A stopped working for previous wave employer;
replace change3=0 if E2662==1;
*E2662 G21 same job as previous wave;

replace tenure3=E2826 if E2826<1997 & E2826>0;
replace tenure3=1996 if E2826==1997;
*E2628 G3 working for someone else;

replace job3=E2734 if E2734<1997 & E2734>0;
*E2734 G43A year started current job;

replace reason3=E2673M1 if reason3==. & E2673M3>=1 & E2673M1<=3;
replace reason3=E2673M2 if reason3==. & E2673M2>=1 & E2673M2<=3;
replace reason3=E2673M3 if reason3==. & E2673M1>=1 & E2673M3<=3;     

*E2673 G28 Why did you leave employer, interested in 1-3;


keep HHID PN tenure3 change3 job3 reason3 counter3;
sort HHID PN;
merge HHID PN using `saved'tenure;
drop _merge;
sort HHID PN;
sleep 1000; save `saved'tenure, replace;
drop _all;

* WAVE 4 *;
use `wave4d'H98g_r;
gen temp=real(HHID);
drop HHID;
gen HHID=temp;
drop temp;
gen temp=real(PN);
drop PN;
gen PN=temp;
drop temp;

*Jon: For efficiency and consistency with older files I change the prefix from F to Q. ;
renpfix F Q;

gen tenure4=.;gen change4=.;gen job4=.;gen reason4=.;gen counter4=.;

replace change4=1 if Q3189>1995 & Q3189<2000;
*Q3189 G26A stopped working for previous wave employer;
replace change4=0 if Q3183==1;
*Q3183 G21 same job as previous wave;

replace tenure4=Q3349 if Q3349<1999 & Q3349>0;
replace tenure4=1998 if Q3349==1999;
*Q3349 G63A year started working for current employer;
*Q3133 G3 working for someone else if ==1;

replace job4=Q3257 if Q3257<1999 & Q3257>0;
*Q3507 G43A year started current job;


replace reason4=Q3194M1 if reason4==. & Q3194M1>=1 & Q3194M1<=3;
replace reason4=Q3194M2 if reason4==. & Q3194M2>=1 & Q3194M2<=3;
replace reason4=Q3194M3 if reason4==. & Q3194M3>=1 & Q3194M3<=3;

*Q3194 G28 Why did you leave employer, interested in 1-3;

replace counter4=1 if tenure4~=. & reason4~=.;

keep HHID PN tenure4 change4 job4 reason4 counter4;
sort HHID PN;
merge HHID PN using `saved'tenure;
drop _merge;
sort HHID PN;
sleep 1000; save `saved'tenure, replace;
drop _all;


* WAVE 5 *;
use `wave5d'H00G_R.DTA; * This file used to be h00_g.dta;
gen temp=real(HHID);
drop HHID;
gen HHID=temp;
drop temp;
gen temp=real(PN);
drop PN;
gen PN=temp;
drop temp;

gen tenure5=.;gen change5=.;gen job5=.;gen reason5=.;gen counter5=.;

renpfix G Q;
replace change5=1 if Q3438>1997 & Q3438<2002;
*Q3438 G26A stopped working for previous wave employer;
replace change5=0 if Q3432==1;
*Q3432 G21 same job as previous wave;

replace tenure5=Q3608 if Q3608<2001 & Q3608>0;
replace tenure5=2000 if Q3608==2001;
*Q3608 G63A year started current job;
*Q3382 G3 working for someone else if ==1, self-employed if ==2;

replace job5=Q3507 if Q3507<2001 & Q3507>0;
*Q3507 G43A year started doing this kind of work;

replace reason5=Q3444M1 if reason5==. & Q3444M1<=3 & Q3444M1>=1;
replace reason5=Q3444M2 if reason5==. & Q3444M2<=3 & Q3444M2>=1;
replace reason5=Q3444M3 if reason5==. & Q3444M3<=3 & Q3444M3>=1;
replace reason5=Q3444M4 if reason5==. & Q3444M4<=3 & Q3444M4>=1;

replace counter5=1 if tenure5~=. & reason5~=.;

keep HHID PN tenure5 change5 job5 reason5 counter5;
sort HHID PN;
merge HHID PN using `saved'tenure;
drop _merge;
summ;
sort HHID PN;
sleep 1000; save `saved'tenure, replace;
drop _all;

* WAVE 6 *;
use `wave6d'H02J_R.DTA; 
gen temp=real(HHID);
drop HHID;
gen HHID=temp;
drop temp;
gen temp=real(PN);
drop PN;
gen PN=temp;
drop temp;

gen tenure6=.;gen change6=.;gen job6=.;gen reason6=.;gen counter6=.;

replace change6=1 if HJ064>1999 & HJ064<2004;

replace change6=0 if HJ058==1;

replace tenure6=HJ249 if HJ249<2003 & HJ249>0;
replace tenure6=2002 if HJ249==2003;

replace job6=HJ170 if HJ170<2003 & HJ170>0;

replace reason6=HJ073M1 if reason6==. & HJ073M1<=3 & HJ073M1>=1;
replace reason6=HJ073M2 if reason6==. & HJ073M2<=3 & HJ073M2>=1;
replace reason6=HJ073M3 if reason6==. & HJ073M3<=3 & HJ073M3>=1;
replace reason6=HJ073M4 if reason6==. & HJ073M4<=3 & HJ073M4>=1;

replace counter6=1 if tenure6~=. & reason6~=.;

keep HHID PN tenure6 change6 job6 reason6 counter6;
sort HHID PN;
merge HHID PN using `saved'tenure;
drop _merge;
summ;
sort HHID PN;
sleep 1000; save `saved'tenure, replace;
drop _all;

* WAVE 7 *;
use `wave7d'H04J_R.DTA; 
gen temp=real(HHID);
drop HHID;
gen HHID=temp;
drop temp;
gen temp=real(PN);
drop PN;
gen PN=temp;
drop temp;

gen tenure7=.;gen change7=.;gen job7=.;gen reason7=.;gen counter7=.;

replace change7=1 if JJ064>2001 & JJ064<2006;

replace change7=0 if JJ058==1;

replace tenure7=JJ249 if JJ249<2005 & JJ249>0;
replace tenure7=2004 if JJ249==2005;

replace job7=JJ170 if JJ170<2005 & JJ170>0;

replace reason7=JJ073M1 if reason7==. & JJ073M1<=3 & JJ073M1>=1;
replace reason7=JJ073M2 if reason7==. & JJ073M2<=3 & JJ073M2>=1;
replace reason7=JJ073M3 if reason7==. & JJ073M3<=3 & JJ073M3>=1;
replace reason7=JJ073M4 if reason7==. & JJ073M4<=3 & JJ073M4>=1;

replace counter7=1 if tenure7~=. & reason7~=.;

keep HHID PN tenure7 change7 job7 reason7 counter7;
sort HHID PN;
merge HHID PN using `saved'tenure;
drop _merge;
summ;
sort HHID PN;
sleep 1000; save `saved'tenure, replace;
drop _all;

* WAVE 8 *;
use `wave8d'H06J_R.DTA; 
gen temp=real(HHID);
drop HHID;
gen HHID=temp;
drop temp;
gen temp=real(PN);
drop PN;
gen PN=temp;
drop temp;

gen tenure8=.;gen change8=.;gen job8=.;gen reason8=.;gen counter8=.;

replace change8=1 if KJ064>2003 & KJ064<2008;

replace change8=0 if KJ058==1;

replace tenure8=KJ249 if KJ249<2007 & KJ249>0;
replace tenure8=2006 if KJ249==2007;

replace job8=KJ170 if KJ170<2007 & KJ170>0;

replace reason8=KJ073M1 if reason8==. & KJ073M1<=3 & KJ073M1>=1;
replace reason8=KJ073M2 if reason8==. & KJ073M2<=3 & KJ073M2>=1;
replace reason8=KJ073M3 if reason8==. & KJ073M3<=3 & KJ073M3>=1;
replace reason8=KJ073M4 if reason8==. & KJ073M4<=3 & KJ073M4>=1;

replace counter8=1 if tenure8~=. & reason8~=.;

keep HHID PN tenure8 change8 job8 reason8 counter8;
sort HHID PN;
merge HHID PN using `saved'tenure;
drop _merge;
summ;
sort HHID PN;
sleep 1000; save `saved'tenure, replace;
drop _all;

* WAVE 9 *;
use `wave9d'H08J_R.DTA; 
gen temp=real(HHID);
drop HHID;
gen HHID=temp;
drop temp;
gen temp=real(PN);
drop PN;
gen PN=temp;
drop temp;

gen tenure9=.;gen change9=.;gen job9=.;gen reason9=.;gen counter9=.;

replace change9=1 if LJ064>2005 & LJ064<2010;

replace change9=0 if LJ058==1;

replace tenure9=LJ249 if LJ249<2009 & LJ249>0;
replace tenure9=2008 if LJ249==2009;

replace job9=LJ170 if LJ170<2009 & LJ170>0;

replace reason9=LJ073M1 if reason9==. & LJ073M1<=3 & LJ073M1>=1;
replace reason9=LJ073M2 if reason9==. & LJ073M2<=3 & LJ073M2>=1;
replace reason9=LJ073M3 if reason9==. & LJ073M3<=3 & LJ073M3>=1;
replace reason9=LJ073M4 if reason9==. & LJ073M4<=3 & LJ073M4>=1;
replace reason9=LJ073M5 if reason9==. & LJ073M5<=3 & LJ073M5>=1;

replace counter9=1 if tenure9~=. & reason9~=.;

keep HHID PN tenure9 change9 job9 reason9 counter9;
sort HHID PN;
merge HHID PN using `saved'tenure;
drop _merge;
summ;
sort HHID PN;
sleep 1000; save `saved'tenure, replace;
drop _all;

* WAVE 10 *;
use `wave10d'H10J_R.DTA; 
gen temp=real(HHID);
drop HHID;
gen HHID=temp;
drop temp;
gen temp=real(PN);
drop PN;
gen PN=temp;
drop temp;

gen tenure10=.;gen change10=.;gen job10=.;gen reason10=.;gen counter10=.;

replace change10=1 if MJ064>2007 & MJ064<2012; //increase years for following waves

replace change10=0 if MJ058==1;

replace tenure10=MJ249 if MJ249<2011 & MJ249>0; //increase years for following waves
replace tenure10=2010 if MJ249==2011; //recode years after the wave cutoff to the base year of the wave (e.g., wave 10's base year is 2010)

replace job10=MJ170 if MJ170<2011 & MJ170>0;

replace reason10=MJ073M1 if reason10==. & MJ073M1<=3 & MJ073M1>=1;
replace reason10=MJ073M2 if reason10==. & MJ073M2<=3 & MJ073M2>=1;
replace reason10=MJ073M3 if reason10==. & MJ073M3<=3 & MJ073M3>=1;
replace reason10=MJ073M4 if reason10==. & MJ073M4<=3 & MJ073M4>=1;
replace reason10=MJ073M5 if reason10==. & MJ073M5<=3 & MJ073M5>=1;

replace counter10=1 if tenure10~=. & reason10~=.;

keep HHID PN tenure10 change10 job10 reason10 counter10;
sort HHID PN;
merge HHID PN using `saved'tenure;
drop _merge;
summ;
sort HHID PN;
sleep 1000; save `saved'tenure, replace;
drop _all;


* WAVE 11 *;
use `wave11d'H12J_R.DTA; 
gen temp=real(HHID);
drop HHID;
gen HHID=temp;
drop temp;
gen temp=real(PN);
drop PN;
gen PN=temp;
drop temp;

gen tenure11=.;gen change11=.;gen job11=.;gen reason11=.;gen counter11=.;

replace change11=1 if NJ064>2009 & NJ064<2014; //increase years for following waves

replace change11=0 if NJ058==1;

replace tenure11=NJ249 if NJ249<2013 & NJ249>0; //increase years for following waves
replace tenure11=2012 if NJ249==2013; //CHECK recode years after the wave cutoff to the base year of the wave (e.g., wave 11's base year is 2012)

replace job11=NJ170 if NJ170<2013 & NJ170>0;

replace reason11=NJ073M1 if reason11==. & NJ073M1<=3 & NJ073M1>=1;
replace reason11=NJ073M2 if reason11==. & NJ073M2<=3 & NJ073M2>=1;
replace reason11=NJ073M3 if reason11==. & NJ073M3<=3 & NJ073M3>=1;
replace reason11=NJ073M4 if reason11==. & NJ073M4<=3 & NJ073M4>=1;

replace counter11=1 if tenure11~=. & reason11~=.;

keep HHID PN tenure11 change11 job11 reason11 counter11;
sort HHID PN;
merge HHID PN using `saved'tenure;
drop _merge;
summ;
sort HHID PN;
sleep 1000; save `saved'tenure, replace;
drop _all;


* WAVE 12 *;
use `wave12d'H14J_R.DTA; 
gen temp=real(HHID);
drop HHID;
gen HHID=temp;
drop temp;
gen temp=real(PN);
drop PN;
gen PN=temp;
drop temp;

gen tenure12=.;gen change12=.;gen job12=.;gen reason12=.;gen counter12=.;

replace change12=1 if OJ064>2011 & OJ064<2016; //increase years for following waves

replace change12=0 if OJ058==1;

replace tenure12=OJ249 if OJ249<2015 & OJ249>0; //increase years for following waves
replace tenure12=2014 if OJ249==2015; //CHECK recode years after the wave cutoff to the base year of the wave (e.g., wave 12's base year is 2012)

replace job12=OJ170 if OJ170<2015 & OJ170>0;

replace reason12=OJ073M1 if reason12==. & OJ073M1<=3 & OJ073M1>=1;
replace reason12=OJ073M2 if reason12==. & OJ073M2<=3 & OJ073M2>=1;
replace reason12=OJ073M3 if reason12==. & OJ073M3<=3 & OJ073M3>=1;
replace reason12=OJ073M4 if reason12==. & OJ073M4<=3 & OJ073M4>=1;

replace counter12=1 if tenure12~=. & reason12~=.;

keep HHID PN tenure12 change12 job12 reason12 counter12;
sort HHID PN;
merge HHID PN using `saved'tenure;
drop _merge;
summ;
sort HHID PN;
sleep 1000; save `saved'tenure, replace;
drop _all;


* WAVE 13 *;
use `wave13d'H16J_R.DTA; 
gen temp=real(HHID);
drop HHID;
gen HHID=temp;
drop temp;
gen temp=real(PN);
drop PN;
gen PN=temp;
drop temp;

gen tenure13=.;gen change13=.;gen job13=.;gen reason13=.;gen counter13=.;

replace change13=1 if PJ064>2013 & PJ064<2018; //increase years for following waves

replace change13=0 if PJ058==1;

replace tenure13=PJ249 if PJ249<2017 & PJ249>0; //increase years for following waves
replace tenure13=2016 if PJ249==2017; //CHECK recode years after the wave cutoff to the base year of the wave (e.g., wave 12's base year is 2012)

replace job13=PJ170 if PJ170<2017 & PJ170>0;

replace reason13=PJ073M1 if reason13==. & PJ073M1<=3 & PJ073M1>=1;
replace reason13=PJ073M2 if reason13==. & PJ073M2<=3 & PJ073M2>=1;
replace reason13=PJ073M3 if reason13==. & PJ073M3<=3 & PJ073M3>=1;
replace reason13=PJ073M4 if reason13==. & PJ073M4<=3 & PJ073M4>=1;

replace counter13=1 if tenure13~=. & reason13~=.;

keep HHID PN tenure13 change13 job13 reason13 counter13;
sort HHID PN;
merge HHID PN using `saved'tenure;
drop _merge;
summ;
sort HHID PN;
sleep 1000; save `saved'tenure, replace;
drop _all;

* WAVE 14 *;
use `wave14d'H18J_R.DTA; 
gen temp=real(hhid);
drop hhid;
gen HHID=temp;
drop temp;
gen temp=real(pn);
drop pn;
gen PN=temp;
drop temp;

gen tenure14=.;gen change14=.;gen job14=.;gen reason14=.;gen counter14=.;

replace change14=1 if QJ064>2014 & QJ064<2018; //increase years for following waves

replace change14=0 if QJ058==1;

replace tenure14=QJ249 if QJ249<2017 & QJ249>0; //increase years for following waves
replace tenure14=2016 if QJ249==2017; //CHECK recode years after the wave cutoff to the base year of the wave (e.g., wave 12's base year is 2012)

replace job14=QJ170 if QJ170<2017 & QJ170>0;

replace reason14=QJ073M1 if reason14==. & QJ073M1<=3 & QJ073M1>=1;
replace reason14=QJ073M2 if reason14==. & QJ073M2<=3 & QJ073M2>=1;
replace reason14=QJ073M3 if reason14==. & QJ073M3<=3 & QJ073M3>=1;
replace reason14=QJ073M4 if reason14==. & QJ073M4<=3 & QJ073M4>=1;

replace counter14=1 if tenure14~=. & reason14~=.;

keep HHID PN tenure14 change14 job14 reason14 counter14;
sort HHID PN;
merge HHID PN using `saved'tenure;
drop _merge;
summ;
sort HHID PN;
sleep 1000; save `saved'tenure, replace;
drop _all;

if $INCLUDE2020 {; 
* WAVE 15 *;
use `wave15d'H20J_R.DTA; 
gen temp=real(hhid);
drop hhid;
gen HHID=temp;
drop temp;
gen temp=real(pn);
drop pn;
gen PN=temp;
drop temp;

gen tenure15=.;gen change15=.;gen job15=.;gen reason15=.;gen counter15=.;

replace change15=1 if RJ064>2015 & RJ064<2018; //increase years for following waves

replace change15=0 if RJ058==1;

replace tenure15=RJ249 if RJ249<2017 & RJ249>0; //increase years for following waves
replace tenure15=2016 if RJ249==2017; //CHECK recode years after the wave cutoff to the base year of the wave (e.g., wave 12's base year is 2012)

replace job15=RJ170 if RJ170<2017 & RJ170>0;

replace reason15=RJ073M1 if reason15==. & RJ073M1<=3 & RJ073M1>=1;
replace reason15=RJ073M2 if reason15==. & RJ073M2<=3 & RJ073M2>=1;
replace reason15=RJ073M3 if reason15==. & RJ073M3<=3 & RJ073M3>=1;
replace reason15=RJ073M4 if reason15==. & RJ073M4<=3 & RJ073M4>=1;

replace counter15=1 if tenure15~=. & reason15~=.;

keep HHID PN tenure15 change15 job15 reason15 counter15;
sort HHID PN;
merge HHID PN using `saved'tenure;
drop _merge;
summ;
sort HHID PN;
sleep 1000; save `saved'tenure, replace;
drop _all;
};


*********************AHEAD WAVE I*******************************;

use `aheadw1'Br21;

sort HHID PN;
gen tenure1=.;
gen job1=.;
gen reason1=.;


renpfix V v;
replace tenure1=v1182 if v1182>0 & v1182<1994;
*V1182 - year started current work:::COMMENT-- HERE I DID NOT FIND THE 
VARIBLE CORRESPONDING TO THE QUESTION "HOW LONG YOU HAVE BEEN WORKING FOR 
THIS EMPLOYER", SO I HAVE CODED THE VARIBLE "YEAR STARTED CURRENT WORK" ;
replace tenure1=1993-v1183 if v1183>0 & v1183<100 & tenure1==.;
gen temp=1993-AGE;
replace temp=temp+v1184;
replace tenure1=temp if temp>1900 & temp<1994 & tenure1==.;
drop temp;

replace job1=v1221 if v1221>0 & v1221<1994;
replace job1=1993-v1222 if v1222>0 & v1222<100 & job1==.;
gen temp=1993-AGE;
replace temp=temp+v1223;
replace job1=temp if temp>1900 & temp<1994 & job1==.;

*V1178 - working for self=2 and someone else=1;
*V1221- when did you start doing this kind of work;

keep HHID PN tenure1 job1 reason1;
summ;
gen temp=real(HHID);
drop HHID;
gen HHID=temp;
drop temp;
gen temp=real(PN);
drop PN;
gen PN=temp;
drop temp;
sort HHID PN;
save `aheadw1'tenure,replace;
drop _all;

*******************************AHEADWAVE2*****************************;
use `aheadw2'A95G_R.dta; * This file used to be Ahd2g.dta;

gen tenure2=.;
gen job2=.;
gen reason2=.;
gen counter2=.;
replace tenure2=D2915 if D2915<1996 & D2915>0;

*D2915 year started working for current employer;

replace job2=D2832 if D2832<1996 & D2832>0;

*D2832year started doing this kind of work;

replace reason2=D2768M1 if D2768M1<=3 & D2768M1>=1;

*D2768M1 Why did you leave employer, interested in 1-3;

replace counter2=1 if tenure2~=. & reason2~=.;

gen temp=real(HHID);
drop HHID;
rename temp HHID;
gen temp=real(PN);
drop PN;
rename temp PN;
keep tenure2 job2 reason2 counter2 HHID PN;
summ;
sort HHID PN;
merge HHID PN using `aheadw1'tenure;
drop _merge;
sort HHID PN;
* rename AHEAD variables for merging;
rename tenure1 atenure1;
rename job1 ajob1;
rename reason1 areason1;
rename tenure2 atenure2;
rename job2 ajob2;
rename reason2 areason2;
summ;
sort HHID PN;
save `aheadw2'tenure,replace;
drop _all;


*************** merge AHEAD data to HRS data ******************;
* merge the AHEAD TENURE.dta file to the HRS TENURE.dta file here;
clear;

use `saved'tenure;
sort HHID PN;
merge HHID PN using `aheadw2'tenure;
drop _merge;

* replace missing HRS WAVE I and WAVE II values with AHEAD WAVE I and WAVE 
II
values;
replace tenure1=atenure1 if tenure1==. & atenure1~=.;
replace job1=ajob1 if job1==. & ajob1~=.;
replace reason1=areason1 if reason1==. & areason1~=.;
replace tenure2=atenure2 if tenure2==. & atenure2~=.;
replace job2=ajob2 if job2==. & ajob2~=.;
replace reason2=areason2 if reason2==. & areason2~=.;
drop a*; * drop AHEAD variables;
sort HHID PN;
sleep 1000; save `saved'tenure, replace;
summ;
* compare summary stats before and after;
cd "$folder\hrs\merge\compare\" ;
summtab, contvars(_all) mean median range excel excelname(tenure.xlsx) replace;
cd "$folder\hrs\merge\" ;
use `saved'tenure.old.dta , clear;
cd "$folder\hrs\merge\compare\" ;
summtab, contvars(_all) mean median range excel excelname(tenure.xlsx) sheetname(Old);



drop _all;
cap log close;











